<?php
/*
Template Name: Google Search Results
*/
?>

<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>

<?php get_header(); ?>

<!-- 
google-results.php 
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>  
   
<!--
Google search results code
~~~ -->

	<?php
    if (empty($_GET['q'])) // if there's nothing in the search box then do something sensible with it
    { 
    ?>
        <div id="page-body-wrapper">
            
            <div id="content">
                
                <div class="post-content">
                        
                    <h2 class="h2-simulate-h1-size-underline"><?php _e('No Results Found','hmth'); ?></h2>
                
                    <p><?php _e('The search box appears to be blank.','hmth'); ?>
                    <br /><?php _e('Please enter some text and try again.','hmth'); ?></p>
                </div> <!-- class="post-content" -->
                
            </div> <!-- id="content" -->
            
        <?php 
        if (!hmt4_get_option('hmt_no_sidebars_mode')) { 
            get_sidebar(); 
        }
        ?>
    
        </div> <!-- id="page-body-wrapper" -->
    
    </div> <!-- post_class -->  
		
	<?php get_footer(); ?>
	

<?php	
}
else
{
?>
	<div id="google-results-body-wrapper">
	   
		<div class="google-search-content">   
			<?php hmt4_echo_option('hmt_google_results'); ?>
		</div> <!-- class="google-search-content" -->

	</div> <!-- id="google-results-body-wrapper" -->
		
	<?php get_footer(); ?>
	
<?php
}
?>

<!--
End of google-results.php
~~~ -->
    